<?php

namespace App\Arisewebapi\Api;

/**
 * Main class file to manage Products.
 *
 * @since 1.0.0
 */
class Image extends Base {

    /**
     * Set component name wil be used to map the Component in the etc/rest/webapi.php endpoints callback.
     *
     * @var string
     * @since 1.0.0
     */
    protected $_component = 'Image';

    /**
     * Will handle migrate image for Arise.
     *
     * @param array $data array containing the request data.
     * @since 1.0.0
     * @return array
     */
    public function migrateImage( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Image\Image')->migrateImage($this->getFilteredParams($data));
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will handle migrate image for Arise.
     *
     * @param array $data array containing the request data.
     * @since 1.0.0
     * @return array
     */
    public function migrateImages( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Image\Image')->migrateImages($this->getFilteredParams($data));
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Verify Feed for image bulk upload.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function verifyFeed( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Image\Image')->verifyFeed($this->getFilteredParams($data));
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }
}