<?php

namespace App\Arisewebapi\Api;

/**
 * Main class file to manage Category and Attributes.
 *
 * @since 1.0.0
 */
class Category extends Base {
	protected $_component = 'Category';

	public function getCategory($param) {
	 try {
		  if ( ! $this->di->getRegistry()->getCurrentShop() ) {
		      return [
		          'success' => false,
		          'msg'     => 'Oops! Shop ID not found'
		      ];
		  }
		  return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Category\Category')->getCategory($param);
	  } catch ( \Exception $e ) {
		  return [
			  'success' => false,
			  'msg'     => $e->getMessage()
		  ];
	  }
	}

	public function getAttributes( $param ) {
		try {
			if ( ! $this->di->getRegistry()->getCurrentShop() ) {
			    return [
			        'success' => false,
			        'msg'     => 'Oops! Shop ID not found'
			    ];
			}
  
			return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Category\Category')->getAttributes( $param );
		} catch ( \Exception $e ) {
			return [
				'success' => false,
				'msg'     => $e->getMessage()
			];
		}
	}

	public function getBrand( $param ) {
		try {
			// if ( ! $this->di->getRegistry()->getCurrentShop() ) {
			//     return [
			//         'success' => false,
			//         'msg'     => 'Oops! Shop ID not found'
			//     ];
			// }
  
			return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Category\Category')->getBrand( $param );
		} catch ( \Exception $e ) {
			return [
				'success' => false,
				'msg'     => $e->getMessage()
			];
		}

	}
}