<?php
namespace App\Arisewebapi\Api;

/**
 * Main class file to manage Admin requests.
 *
 * @since 1.0.0
 */
class Admin extends Base {

    /**
     * Will redirect admin endpoints to respective component.
     *
     * @var string
     * @since 1.0.0
     */
	protected $_component = 'Admin';


    /**
     * Will delete data from DB.
     *
     * @param array $params array containing the request param.
     * @since 1.0.0
     * @return array
     */
    public function deleteFromDB( $params = array() ) {
        return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Admin\Admin')->deleteFromDB( $this->getFilteredParams( $params ) );
    }

    /**
     * Will read data from DB.
     *
     * @param array $params array containing the request param.
     * @since 1.0.0
     * @return array
     */
    public function readFromDB( $params = array() ) {
        return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Admin\Admin')->readFromDB( $this->getFilteredParams( $params ) );
    }
}