<?php
return [
    'restapi' => [
        'v1' => [
            'GET' => [
                'routes' => [
                    'marketplaceswebhooks' => [
                        'url' => 'marketplaceswebhooks',
                        'class' => 'App\Apiconnect\Components\Webhook',
                        'method' => 'marketplaceswebhooks',
                        'resource' => 'marketplaceswebhooks'
                    ],
                    'appsWebhooks' => [
                        'url' => 'appsWebhooks',
                        'class' => 'App\Apiconnect\Api\Apps',
                        'method' => 'appsWebhooks',
                        'resource' => 'appsWebhooks',
                    ],
                    'product' => [
                        'url' => 'product',
                        //;        'class'=> 'App\Apiconnect\Api\Product',
                        'method' => 'get',
                        'resource' => 'product/get',
                        'component' => 'Product',
                        //        'response_class' => 'App\Apiconnect\Api\Response\Product'
                    ],
                    'productvariant' => [
                        'url' => 'product',
                        //;        'class'=> 'App\Apiconnect\Api\Product',
                        'method' => 'get',
                        'resource' => 'product/get',
                        'component' => 'Product',
                        'response_class' => 'App\Apiconnect\Api\Response\Product'
                    ],
                    'order' => [
                        'url' => 'order',
                        'method' => 'get',
                        'resource' => 'order/get',
                        'component' => 'Order'
                    ],
                    'order/shipment' => [
                        'url' => 'order/shipment',
                        'method' => 'get',
                        'resource' => 'order/shipment',
                        'component' => 'Order\Shipment',
                    ],
                    'order/cancellation' => [
                        'url' => 'order/cancellation',
                        'method' => 'get',
                        'resource' => 'order/cancellation',
                        'component' => 'Order\Cancellation',
                    ],
                    'order/refund' => [
                        'url' => 'order/refund',
                        'method' => 'get',
                        'resource' => 'order/refund',
                        'component' => 'Order\Refund',
                    ],
                    'apps' => [
                        'url' => 'apps',
                        'class' => 'App\Apiconnect\Api\Apps',
                        'method' => 'get',
                        'resource' => 'apps/get'
                    ],
                    'shop' => [
                        'url' => 'shop',
                        'method' => 'get',
                        'resource' => 'shop/get',
                        'component' => 'Shop'
                    ],
                    'app' => [
                        'url' => 'app',
                        'class' => 'App\Apiconnect\Api\Apps',
                        'method' => 'getAppConfig',
                        'resource' => 'app/get'
                    ],
                    // 'warehouse' => [
                    //     'url' => 'warehouse',
                    //     'class'=> 'App\Apiconnect\Api\Warehouse',
                    //     'method' => 'get',
                    //     'resource' => 'apps/get'
                    // ],
                    'token' => [
                        'url' => 'token',
                        'class' => 'App\Apiconnect\Api\Token',
                        'method' => 'get',
                        'resource' => 'token/get',
                        'required' => ['shop_id']
                    ],
                    'app-shop' => [
                        'url' => 'app-shop',
                        'class' => 'App\Apiconnect\Api\AppShop',
                        'method' => 'get',
                        'resource' => 'app-shop/get'
                    ],
                    'category' => [
                        'url' => 'category',
                        'method' => 'get',
                        'resource' => 'category/get',
                        'component' => 'Category',
                    ],
                    'connected-accounts' => [
                        'url' => 'connected-accounts',
                        'class' => 'App\Apiconnect\Api\AppShop',
                        'method' => 'getConnectedAccounts',
                        'resource' => 'connected-accounts/get'
                    ]
                ],
            ],
            'POST' => [
                'routes' => [
                    'product' => [
                        'url' => 'product',
                        'method' => 'create',
                        'resource' => 'product/create',
                        'component' => 'Product',
                    ],
                    'order' => [
                        'url' => 'order',
                        'method' => 'create',
                        'resource' => 'order/create',
                        'component' => 'Order',
                    ],
                    'order/acknowledge' => [
                        'url' => 'order/acknowledge',
                        'method' => 'acknowledge',
                        'resource' => 'order/acknowledge',
                        'component' => 'Order',
                    ],
                    'order/sync/register' => [
                        'url' => 'order/sync/register',
                        'method' => 'syncRegister',
                        'resource' => 'order/sync/register',
                        'component' => 'Order',
                    ],
                    'order/sync/unregister' => [
                        'url' => 'order/sync/unregister',
                        'method' => 'syncUnregister',
                        'resource' => 'order/sync/unregister',
                        'component' => 'Order',
                    ],
                    'order/shipment' => [
                        'url' => 'order/shipment',
                        'method' => 'create',
                        'resource' => 'order/shipment',
                        'component' => 'Order\Shipment',
                    ],
                    'order/cancellation' => [
                        'url' => 'order/cancellation',
                        'method' => 'create',
                        'resource' => 'order/cancellation',
                        'component' => 'Order\Cancellation',
                    ],
                    'order/refund' => [
                        'url' => 'order/refund',
                        'method' => 'create',
                        'resource' => 'order/refund',
                        'component' => 'Order\Refund',
                    ],
                    'apps' => [
                        'url' => 'apps',
                        'class' => 'App\Apiconnect\Api\Apps',
                        'method' => 'create',
                        'resource' => 'apps/create'
                    ],
                    'app-shop' => [
                        'url' => 'app-shop',
                        'class' => 'App\Apiconnect\Api\AppShop',
                        'method' => 'set',
                        'resource' => 'app-shop/set'
                    ],
                    'shop' => [
                        'url' => 'shop',
                        'component' => 'Shop',
                        'method' => 'getShopDetails',
                        'resource' => 'shop/get'
                    ],
                    'add-app-shop' => [
                        'url' => 'add-app-shop',
                        'class' => 'App\Apiconnect\Api\AppShop',
                        'method' => 'addAppShop',
                        'resource' => 'add-app-shop'
                    ],
                    'changeAppShopStatus' => [
                        'url' => 'changeAppShopStatus',
                        'class' => 'App\Apiconnect\Api\AppShop',
                        'method' => 'changeAppShopStatus',
                        'resource' => 'change-app-shop-status'
                    ],
                    'subuser-status-change' => [
                        'url' => 'subuser/status',
                        'class' => 'App\Apiconnect\Api\SubUser',
                        'method' => 'changeSubUserStatus',
                        'resource' => 'subuser/changestatus'
                    ],
                ],

            ],
            'PUT' => [
                'routes' => [
                    'product' => [
                        'url' => 'product',
                        'method' => 'update',
                        'resource' => 'product/update',
                        'component' => 'Product',
                    ],
                    'order' => [
                        'url' => 'order',
                        'method' => 'update',
                        'resource' => 'order/update',
                        'component' => 'Order',
                    ],
                    'apps' => [
                        'url' => 'apps',
                        'class' => 'App\Apiconnect\Api\Apps',
                        'method' => 'update',
                        'resource' => 'apps/update'
                    ],
                    'update/ced_app_shops' => [
                        'url' => 'update/ced_app_shops',
                        'class' => 'App\Apiconnect\Api\AppUninstall',
                        'method' => 'checkAndUpdateCedAppShop',
                        'resource' => 'app-uninstall/checkAndUpdateCedAppShop',
                    ],
                    'set/appUninstall' => [
                        'url' => 'set/appUninstall',
                        'class' => 'App\Apiconnect\Api\AppUninstall',
                        'method' => 'setAppUninstallKeyInAppShop',
                        'resource' => 'app-uninstall/setAppUninstallKeyInAppShop',
                    ]
                ],
            ],
            'DELETE' => [
                'routes' => [
                    'product' => [
                        'url' => 'product',
                        'method' => 'delete',
                        'resource' => 'product/delete',
                        'component' => 'Product',
                    ],
                    'apps' => [
                        'url' => 'apps',
                        'class' => 'App\Apiconnect\Api\Apps',
                        'method' => 'delete',
                        'resource' => 'apps/delete'
                    ],
                    'app-shop' => [
                        'url' => 'app-shop',
                        'class' => 'App\Apiconnect\Api\AppShop',
                        'method' => 'delete',
                        'resource' => 'app-shop/delete'
                    ],
                    'order' => [
                        'url' => 'order',
                        'method' => 'delete',
                        'resource' => 'order/delete',
                        'component' => 'Order',

                    ],
                    'app/uninstall' => [
                        'url' => 'app/uninstall',
                        'class' => 'App\Apiconnect\Api\AppUninstall',
                        'method' => 'uninstallapp',
                        'resource' => 'app-unistall/uninstallApp'
                    ]
                ],
            ],
        ],
    ],
    'marketplace-modules' => [
        'ebay' => 'Ebaywebapi',
        'shopify' => 'Shopifywebapi'
    ]
];
