<?php

namespace App\Apiconnect\Controllers;

use Phalcon\DI;
use App\Core\Models\User;

class UserController extends \App\Core\Controllers\BaseController
{

    public function createAction()
    {

        $contentType = $this->request->getHeader('Content-Type');
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }
        $resources = [
           [
              "module" => "core",
              "controller" => "token",
              "action" => "get"
           ],
           [
              "module" => "core",
              "controller" => "token",
              "action" => "create"
           ],
           [
              "module" => "core",
              "controller" => "token",
              "action" => "remove"
           ],
           [
              "module" => "core",
              "controller" => "token",
              "action" => "getTokenByRefresh"
           ],
           [
              "module" => "webapi",
              "controller" => "rest",
              "action" => "v1"
           ],
           [
              "module" => "webapi",
              "controller" => "apps/get",
              "action" => "get"
           ],
           [
              "module" => "webapi",
              "controller" => "app/get",
              "action" => "get"
           ],
        ];
        $resourceIds = [];
        foreach($resources as $resource){
            $res = \App\Core\Models\Resource::findFirst([$resource]);
            if($res)
                $resourceIds[] = (string)$res->getId();

        }
        $rawBody['resources'] = $resourceIds;
       
        if (isset($rawBody['app_id'])) {
            $rawBody['apps'] = [
                [
                    "auth_url" => $rawBody['domain'],
                    "domain" => $rawBody['domain'],
                    "app_id" => (string)$rawBody['app_id'],
                    "app_name" => $rawBody['marketplace'],
                    "app_marketplace" => $rawBody['marketplace']
                ]
            ];
        } else {
            $result = ['success' => false, 'code' => 'invalid_app_id', 'message' => 'Invalid App id', 'data' => ['errors' => ['Invalid app id']]];
            return $this->prepareResponse($result);
        }


        try {
        $user = new \App\Core\Models\User\SubUser;
        $subUserResponse = $user->createUser($rawBody, true, true);
        $subUserResponse['resources_aligned'] = $rawBody['resources'];
        if ($subUserResponse['success']) {
            $rawBody = [
                "user" => $subUserResponse['data']['_id'],
                "app_id" => $rawBody['app_id'],
                "duration" > "3600",
                "title" => $rawBody['marketplace']." REFRESH TOKEN",
                "type" => "refresh"
            ];

                $userGeneratedTokens = new \App\Core\Models\UserGeneratedTokens;
                $tokenResponse = $userGeneratedTokens->createToken($rawBody,false);
                if($tokenResponse['success']) {
                    foreach ($subUserResponse['data']['apps'] as &$app) {
                        if($app['app_id'] == $rawBody['app_id']) {
                            $app['refresh_token'] = $tokenResponse['data']['token'];
                            break;
                        }
                    }
                    return $this->prepareResponse($subUserResponse);
                } else {
                    return $this->prepareResponse($tokenResponse);
                }


        } else {
            return $this->prepareResponse($subUserResponse);
        }
         } catch (\Exception $e) {
        print_r($e->getTraceAsString());
               print_r($e->getMessage());
            }


    }

}
