<?php

namespace App\Apiconnect\Controllers;

use Phalcon\Http\Response;
use Aws\DynamoDb\DynamoDbClient;

/**
 * Class RequestController
 * @package App\Shopifywebapi\Controllers
 */
class RequestController extends \App\Core\Controllers\BaseController
{

    public $_postData;

    public $_targetMarketplace;

    public $_errorMsg;

    public $_appConfig;


    public function initialize()
    {
        if ($this->request->isPost()) {
            $this->_postData = !empty($this->request->getJsonRawBody(true)) ? $this->request->getJsonRawBody(true) : $this->request->getPost();
        }else{
            $this->_postData = $shop = $this->request->get();
        }
        $this->di->getLog()->logContent(date("d-m-y H:i:s").' installation Postdata => '.print_r($this->_postData,true),'info','requestControllerPostData.log');

        if (empty($this->_postData)) $this->_errorMsg = 'App missing. Please contact support.';
        $this->_appConfig = $this->di->getRegistry()->getAppConfig();
        if($this->_appConfig){
            if (empty($this->_appConfig) || !isset($this->_appConfig['marketplace'])) $this->_errorMsg = 'Sorry !! Requested App does not exist. Please contact support.';
            $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($this->_appConfig['marketplace']) ?: ucfirst($this->_appConfig['marketplace']);
            $this->_targetMarketplace = $targetMarketplace;
        }else{
            $this->_errorMsg = 'Internal Error. Please re - install the app';
        }
    }

    
    public function getPrivateInstallationFormAction()
    {
        $marketplace = strtolower($this->_targetMarketplace);
        $path = BP . DS . 'app' . DS . 'code' . DS . $marketplace . DS . 'view' . DS . 'auth' . DS . 'install.phtml';
        if (file_exists($path)) {
            $data = $this->di->getObjectManager()->get('App\Apiconnect\Components\Helper')->removeBrowserEnteries($this->_postData);
            $authUrl = $this->di->getConfig()->get('backend_base_url');
            if (!empty($authUrl)) {
                $authUrl .= $marketplace . '/auth/install/?';
                $authUrl .= http_build_query($data);
                return $this->response->redirect($authUrl);
            } else {
                return $this->prepareResponse(['success' => false, 'code' => 'Auth_url_not_found' , 'message' => 'Auth Url was not found in config file']);
            }
        } else {
            return $this->prepareResponse(['success' => false, 'code' => 'File_not_found' , 'message' => 'File does not exist']);
        }
    }

    public function authAction()
    {
        if (!empty($this->_errorMsg)) {
            $this->di->getLog()->logContent(date("H:i:s")." error message => ". print_r($this->_errorMsg,true),"info", "Authorization" . DS . date('d-m-Y') . DS . "auth.log");
            return $this->prepareResponse(['success' => false, 'message' => $this->_errorMsg]);
        }
        $authData = $this->di->getObjectManager()->get('\App\\' . $this->_targetMarketplace . '\\Components\Route\Handler')->requestRedirectAuthUrl($this->_postData);
        $this->di->getLog()->logContent(date("H:i:s")." auth data => ". print_r($authData,true),"info", "Authorization" . DS . date('d-m-Y') . DS . "auth.log");
        if (!($authData['success']) && isset($authData['force_redirect'])) return $this->response->redirect($this->di->getConfig()->get('frontend_force_app_url') . '?' . http_build_query($authData));

        if (isset($this->_appConfig['sub_app_id'])) {
            $this->session->set("sub_app_id", $this->_appConfig['sub_app_id']);
        } else {
            $this->session->set("sub_app_id", false);
        }
        if (isset($this->_postData['state'])) {
            $this->session->set("requested_state", $this->_postData['state']);
        } else {
            $this->session->set("requested_state", false);
        }
        if (!($authData['success'])) return $this->prepareResponse($authData);
        return $this->response->redirect($authData['authUrl'], true);
    }

    public function commenceAuthAction()
    {
        if (!empty($this->_errorMsg)) {
            $this->di->getLog()->logContent(date("H:i:s")." error message => ". print_r($this->_errorMsg,true),"info", "Authorization" . DS . date('d-m-Y') . DS . "commence_auth.log");
            return $this->prepareResponse(['success' => true, 'msg' => $this->_errorMsg]);
        }
        $handler = $this->di->getObjectManager()->get('\App\\' . $this->_targetMarketplace . '\\Components\Route\Handler');
        $result = $handler->processAuth();
        $this->di->getLog()->logContent(date("H:i:s")." result from processAuth => ". print_r($result, true),"info", "Authorization" . DS . date('d-m-Y') . DS . "commence_auth.log");
        if ($result['success']) {
            $helper = $this->di->getObjectManager()->get('\App\Core\Components\Helper');
            $date1 = new \DateTime('+360 second');
            if (!isset($result['data']['state'])) {
                $result['data']['marketplace'] = $this->_appConfig['marketplace'];
                $token = [
                    "data" => $result['data'],
                    "exp" => $date1->getTimestamp()
                ];

                $token = $helper->getJwtToken($token, 'RS256', false, $this->_appConfig['private_key'] ?? false);
                $result = ['data' => $token, 'app_code' => $this->_appConfig['app_code'], 'success' => 1];
            }

            if (isset($this->_appConfig['app_code'])) $result['app_code'] = $this->_appConfig['app_code'];
            $result['marketplace'] = $this->_appConfig['marketplace'];

            if ($state = $this->session->get("requested_state")) {
                $this->di->getLog()->logContent('Session state = '.print_r($state,true),'info','state.log');
                $result['state'] = $state;
                $this->session->delete("requested_state");
            }elseif (isset($this->_postData['state'])){
                $this->di->getLog()->logContent('Postdata state = '.print_r($this->_postData['state'],true),'info','state.log');
                $result['state'] = $this->_postData['state'];
            }

            if ($host = $this->di->getRequest()->get('host'))  $result['host'] = $host;

            if (isset($result['state'])){
                $state =  json_decode($result['state'], true);
                if (!isset($state['frontend_redirect_uri']) && !empty($this->_appConfig['frontend_uri']))
                    $result['frontend_redirect_uri'] = $this->_appConfig['frontend_uri'];
                if (isset($state['home_redirect_url']))
                    return $this->response->redirect($handler->getUrl($state['home_redirect_url'], '', $result), true);
                return $this->response->redirect($handler->getUrl($this->_appConfig['url'], '', $result), true);

            }
            if (!empty($this->_appConfig['frontend_uri'])) $result['frontend_redirect_uri'] = $this->_appConfig['frontend_uri'];
            return $this->response->redirect($handler->getUrl($this->_appConfig['url'], '', $result), true);

        } elseif (isset($result['message'])) {
            if ($state = $this->session->get("requested_state")) {
                $result['state'] = $state;
                if (!isset($state['frontend_redirect_uri']) && !empty($this->_appConfig['frontend_uri']))
                    $result['frontend_redirect_uri'] = $this->_appConfig['frontend_uri'];
            }
            $result['marketplace'] = $this->_appConfig['marketplace'];
            $result['app_code'] = $this->_appConfig['app_code'];
            return $this->response->redirect($handler->getUrl($this->_appConfig['url'], '', $result), true);
        } elseif(isset($result['auth_url'])){
            return $this->response->redirect($result['auth_url'], true);
        }
    }

    public function saveSellerInfoAction()
    {

        if (isset($this->_postData['test'])) {
            $path = 'shopifywebapi' . DS . 'view' . DS . 'email' . DS . 'review.volt';
            $data['email'] = 'shuklaswati881@gmail.com';
            $data['path'] = $path;
            $data['name'] = "Pankaj Aswal";
            $data['subject'] = 'Account Pending for Facebook Approval';
            $data['aksb'] = $this->di->getConfig()->backend_base_url . 'front/shopify/email/aksb.js';
            $data['logo'] = $this->di->getConfig()->backend_base_url . 'front/shopify/email/logo.png';
            $data['fb_banner'] = $this->di->getConfig()->backend_base_url . 'front/shopify/email/fb_banner.jpg';

            $response = $this->di->getObjectManager()->get('App\Core\Components\SendMail')->send($data);

            print_r($response);
            die('test 00');
        }

        if (!isset($this->_postData['sAppId']) || !isset($this->_postData['shop_url'])) {
            return $this->prepareResponse([
                'success' => false,
                'message' => 'Field Missing. Kindly provide all data.'
            ]);
        }

        $shopData = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->getShop(false, false, ["shop_url" => $this->_postData['shop_url']], ['shop_url']);

        if (isset($shopData['data']['datos']['info'])) {
            if (isset($this->_postData['status'])) {
                $info = $shopData['data']['datos']['info'];

                $info['status'] = isset($this->_postData['status']) ? $this->_postData['status'] : $info['status'];
                $info['name'] = isset($this->_postData['name']) ? $this->_postData['name'] : $info['name'];
                $info['email'] = isset($this->_postData['email']) ? $this->_postData['email'] : $info['email'];
                $info['category'] = isset($this->_postData['category']) ? $this->_postData['category'] : $info['category'];
                $info['facebook_id'] = isset($this->_postData['facebook_id']) ? $this->_postData['facebook_id'] : $info['facebook_id'];

                $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                    false,
                    false,
                    [
                        'shop_url' => $this->_postData['shop_url'],
                        'info' => $info
                    ],
                    ['shop_url']
                );
                return $this->prepareResponse($shop);
            } else {
                return $this->prepareResponse([
                    'success' => false,
                    'message' => 'Invalid Request Type'
                ]);
            }
        } else {
            $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                false,
                false,
                [
                    'shop_url' => $this->_postData['shop_url'],
                    'info' => [
                        'name' => $this->_postData['name'],
                        'email' => $this->_postData['email'],
                        'category' => $this->_postData['category'],
                        'facebook_id' => $this->_postData['facebook_id'],
                        'status' => isset($this->_postData['status']) ? $this->_postData['status'] : 'UNDER_REVIEW'
                    ]
                ],
                ['shop_url']
            );

            $path = 'shopifywebapi' . DS . 'view' . DS . 'email' . DS . 'review.volt';
            $data['email'] = $this->_postData['email'];
            $data['path'] = $path;
            $data['name'] = $this->_postData['name'];
            $data['subject'] = 'Account Pending for Facebook Approval';
            $data['aksb'] = $this->di->getConfig()->backend_base_url . 'front/shopify/email/aksb.js';
            $data['logo'] = $this->di->getConfig()->backend_base_url . 'front/shopify/email/logo.png';
            $data['fb_banner'] = $this->di->getConfig()->backend_base_url . 'front/shopify/email/fb_banner.jpg';

            $response = $this->di->getObjectManager()->get('App\Core\Components\SendMail')->send($data);

            return $this->prepareResponse([
                'success' => true,
                'message' => 'Your Application has been successfully Submitted.'
            ]);
        }
    }

    public function removeShopsAction(){
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $apps_shop = $mongo->getCollection('apps_shop');
        $apps_shop->deleteMany([]);
        return $this->prepareResponse(['success'=>true,'message'=>'Shops deleted successfully']);
    }

    public function updateSchemaAction()
    {
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $options = ['typeMap'   => ['root' => 'array', 'document' => 'array']];
        $apps_shop = $mongo->getCollection('apps_shop');
        $apps = $mongo->getCollection('apps');
        $appsShops = $apps_shop->aggregate([
            [
                '$unwind' => '$apps'
            ],
            [
                '$match' => [
                    'apps.shopify_app_id' => ['$exists' => 1],
                    'apps.cif_app_id' => ['$exists' => 0],
                    'apps.is_private' => ['$exists' => 0]
                ]
            ],
            [
                '$project' => [
                    'apps.shopify_app_id' => 1,
                    'id' => 1,
                    '_id' => 0
                ]
            ],

        ], $options)->toArray();

        foreach ($appsShops as $app) {
            $cif_app_id = $mongo->getCounter('apps_id');
            $bulkInsertData[] = [
                '_id' => $cif_app_id,
                'id' => $cif_app_id,
                'is_visible' => false,
                'shop_id' => $app['id'],
            ];

            $bulkUpdateArray[] = [
                'updateOne' => [
                    ['id' => $app['id']],
                    ['$set' => ['apps.$[app].is_private' => true, 'apps.$[app].cif_app_id' => $cif_app_id]],
                    ['arrayFilters' => [['app.shopify_app_id' => $app['apps']['shopify_app_id']]]]
                ]
            ];
        }

        if (!empty($bulkUpdateArray) && !empty($bulkInsertData)) {
            $bulkUpdate = $apps_shop->BulkWrite($bulkUpdateArray, ['w' => 1]);
            $bulkInsert = $apps->insertMany($bulkInsertData);
        }


        if ($bulkUpdate->getModifiedCount() > 0 && $bulkInsert->getInsertedCount() > 0) {
            return [
                'success' => true,
                'message' => $bulkUpdate->getModifiedCount() . " apps-shop updated. and" . $bulkInsert->getInsertedCount() . " apps inserted in apps collection."
            ];
        }

        return [
            'success' => false,
            'message' => 'Trouble updating apps_shops schema.'
        ];
    }
}
