<?php

namespace App\Apiconnect\Test\Models\Apps;

/**
 * Class ShopTest
 */
class ShopTest extends \App\Core\Components\UnitTestApp
{
    /*
     * Add shop in user users
     */
    public function testAddShop(){
        $helper = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
        $data =  [
            'name' => 'Ronald',
            'domain' => 'test123.com',
            'warehouses' => [
                ['name' => 'wh1', 'location' => 'lucknow'],
                ['name' => 'wh2', 'location' => 'Kanpur']
            ] 
        ];
        $result = $helper->addShop(10,false,$data);

        $this->assertTrue($result['success']);

        $helper = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
        $data =  [
            'name' => 'Ronald',
            'domain' => 'test123.com',
            'warehouses' => [
                ['name' => 'wh1', 'location' => 'lucknow'],
                ['name' => 'wh2', 'location' => 'Kanpur']
            ]
        ];
        $result = $helper->addShop(10,1,$data);

        $this->assertTrue($result['success']);
        $data =  [
            'name' => 'Ronald',
            'domain' => 'test123.com2',
            'warehouses' => [
                ['name' => 'wh1', 'location' => 'lucknow123'],
                ['name' => 'wh2', 'location' => 'Kanpur']
            ]
        ];
        $result = $helper->addShop(10,2,$data);

        $this->assertTrue($result['success']);
    }

    public function testChangeAppShopStatus()
    {
        $helper = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
        $data =  [
          'shop_id' => "41",
          "app_code" => "test",
          'status" => "active'   
        ];
        $result = $helper->changeAppShopStatus($data['shop_id'], $data['app_code'], $data['status']);
        $response = 1;
        $this->assertEquals(
            $response,
            $result
        );

        $data =  [
            'shop_id' => "41",
            "app_code" => "test",
            'status" => "inactive'   
          ];
          $result = $helper->changeAppShopStatus($data['shop_id'], $data['app_code'], $data['status']);
          $response = 1;
          $this->assertEquals(
              $response,
              $result
          );
    }


}