<?php

namespace App\Apiconnect\Test\Models\Apps;

/**
 * Class ShopTest
 */
class SubUserTest extends \App\Core\Components\UnitTestApp
{
    /*
     * Add shop in user users
     */
    public function testChangeSubUserStatus(){

        $input01 = [
            'userId' => '1',
            'status' => 'block'
        ];

        $input02 = [
            'userId' => '1',
            'status' => 'active'
        ];

        $input03 = [
            'userId' => '1',
            'status' => 'activate'
        ];

        $input04 = [
            'userId' => 6
        ];

        $result01= [
            'success' => true,
            'message' => 'User is block!'
        ];

        $result02 = [
            'success' => true,
            'message' => 'User is active!',
        ];

        $result03 = [
            'success' => false,
            'message' => 'Invalid status type! Allowed status are block, active'
        ];

        $result04 = [
            'success' => false,
            'message' => 'Invalid input!',
        ];

        // when the status type is already set in sub user 
        $result00 = [
            'success' => false,
            'message' => 'Trouble in changing user status to active!',
        ];
                
        $output = $this->di->getObjectManager()->get("\App\Apiconnect\Api\SubUser")->changeSubUserStatus($input02);

        $this->assertEquals(
            $result02,
            $output
        );
    }

}