<?php

namespace App\Apiconnect\Models\Apps;

use App\Apiconnect\Models\Apps;

class Shop extends \App\Core\Models\BaseMongo
{
    protected $table = 'apps_shop';

    protected $isGlobal = true;

    /**
     * Add Shop in user_details table
     *
     * @param array $shopDetails ['name'=>'','domain'=>'','marketplace'=>'','warehouses'=>[['name'=>'','location'=>'']]]
     * @param int $userId
     * @param array $uniqueKeys ['domain', '_id']
     * @return array with success true/false and message
     */
    public function addShopOld($appId = false, $subAppId = false, $shopDetails, $uniqueKeys = ['domain'], $includeAppIdFilter = true)
    {

        if (empty($shopDetails)) {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insuficiant_data'];
        }

        $appConfig = $this->di->getRegistry()->getAppConfig();

        if ($appConfig && !$appId) {
            $appId = $appConfig['_id'];
        }

        if ($appConfig && !$subAppId) {
            $subAppId = $appConfig['sub_app_id'] ?? false;
        }
        $bulk = true;
        if (!isset($shopDetails[0])) {
            $shopDetails = [$shopDetails];
            $bulk = false;
        }

        unset($shopDetails['app_id']);
        unset($shopDetails['sub_apps']);

        $result = [];
        foreach ($shopDetails as $shopDetail) {
            $collection = $this->getCollection();
            $filters = [];
            if ($includeAppIdFilter) {
                $filters['app_id'] = $appId;
            }

            /*if($subAppId){
                $filters['sub_apps'] = $subAppId;
            }*/
            foreach ($uniqueKeys as $key) {
                if (isset($shopDetail[$key])) {
                    $filters["{$key}"] = $shopDetail[$key];
                }
            }

            //$this->di->getLog()->logContent('result = '.json_encode($filters),'critical','shopify_home_auth.log');

            if (isset($shopDetail['_id'])) {
                unset($shopDetail['_id']);
            }
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            try {
                $response = $collection->findOne($filters, $options);
                if ($subAppId) {
                    if (empty($response)) {
                        /* add sub app in shopDetails*/
                        $shopDetail['sub_apps'] = [$subAppId];
                        $shopDetail['app_id'] = $appId;
                        $shopDetail['_id'] = $this->getCounter('app_shop_id');
                        $shop = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
                        $shop->setData($shopDetail);
                        $shop->save();
                        $result[] = [
                            'success' => true,
                            'message' => 'Shop Added  Successfuly app',
                            'data' => [
                                'shop_id' => $shopDetail['_id']
                            ]
                        ];
                        continue;
                    } else {
                        $shopDetail['sub_apps'] = $response['sub_apps'];
                        $apps = array_flip($shopDetail['sub_apps']);
                        if (isset($response['app_code'])) {
                            unset($response['app_code']);
                        }

                        if (isset($response['group_code'])) {
                            unset($response['group_code']);
                        }

                        $installedApps = array_merge($response['apps'] ?? [], $shopDetail['apps'] ?? []);
                        $shopDetail['apps'] = $installedApps;

                        if ($this->isAppUpdated($response['apps'], $shopDetail['apps']) || !isset($apps[$subAppId])) {
                            if (!isset($apps[$subAppId]))
                                $shopDetail['sub_apps'][] = $subAppId;

                            $updateResult = $collection->updateOne(
                                $filters,
                                ['$set' => $shopDetail]
                            );

                            if ($updateResult->getMatchedCount()) {
                                $result[] = [
                                    'success' => true,
                                    'message' => 'Shop Updated Successfuly subapp',
                                    'data' => [
                                        'shop_id' => $response['_id']
                                    ]
                                ];
                                continue;
                            } else {
                                $result[] = ['success' => false, 'message' => 'Shop Update Failed'];
                                continue;
                            }
                        } else {
                            $result[] = [
                                'success' => true,
                                'message' => 'Shop up-to-date',
                                'data' => [
                                    'shop_id' => $response['_id']
                                ]
                            ];
                            continue;
                        }
                    }
                } else {
                    if (empty($response)) {
                        /* add sub app in shopDetails*/
                        $shopDetail['sub_apps'] = [];
                        $shopDetail['app_id'] = $appId;
                        $shopDetail['_id'] = $this->getCounter('app_shop_id');
                        $shop = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
                        $shopDetail['created_at'] = new \MongoDB\BSON\UTCDateTime();
                        $shop->setData($shopDetail);
                        $shop->save();

                        $result[] = [
                            'success' => true,
                            'message' => 'Shop Added Successfuly app',
                            'data' => [
                                'shop_id' => $shopDetail['_id']
                            ]
                        ];
                        continue;
                    } else {
                        $shopDetail['sub_apps'] = $response['sub_apps'];

                        if (isset($response['app_code'])) {
                            unset($response['app_code']);
                        }

                        if (isset($response['group_code'])) {
                            unset($response['group_code']);
                        }

                        $installedApps = array_merge($response['apps'], $shopDetail['apps']);
                        $shopDetail['apps'] = $installedApps;

                        if ($this->isAppUpdated($response['apps'], $shopDetail['apps'])) {
                            $updateResult = $collection->updateOne(
                                $filters,
                                ['$set' => $shopDetail]
                            );
                            if ($updateResult->getMatchedCount()) {
                                $result[] = [
                                    'success' => true,
                                    'message' => 'Shop Updated Successfuly app',
                                    'data' => [
                                        'shop_id' => $response['_id']
                                    ]
                                ];
                                continue;
                            } else {
                                $result[] = ['success' => false, 'message' => 'Shop Update Failed'];
                                continue;
                            }
                        } else {
                            $result[] = [
                                'success' => true,
                                'message' => 'Shop up-to-date',
                                'data' => [
                                    'shop_id' => $response['_id']
                                ]
                            ];
                            continue;
                        }
                    }
                }
            } catch (\Exception $e) {
                $result[] = ['success' => false, 'message' => $e->getMessage(), 'code' => 'unknown_exception'];
            }
        }
        //$this->di->getLog()->logContent('result = '.json_encode($result),'critical','shopify_home_auth.log');
        return $bulk ? $result : $result[0];
    }

    public function formatShopData(&$shopData, $shopDetail, $appConfig, $partialUpdate, $matchedPosition = 0)
    {
        $appData = [];

        if (!empty($shopData['apps']) && $partialUpdate) {
            foreach ($shopData['apps'] as $key => $apps) {
                if ($apps['app_code'] == $appConfig['app_code']) {
                    $appData = $apps;
                }
            }
        }

        foreach ($shopDetail as $key => $value) {
            $appData[$key] = $value;
        }

        $appData['app_code'] = $appConfig['app_code'];
        $appData['app_id'] = $appConfig['_id'];
        $appData['sub_app_id'] = $appConfig['sub_app_id'];
        if (isset($shopDetail['cif_app_id'])) {
            $appData['cif_app_id'] = $shopDetail['cif_app_id'];
        }
        $appData['active'] = $shopDetail['active'] ?? true;
        $shopData['apps'][$matchedPosition] = $appData;
    }

    public function checkForCedcommerceApp($remote_shop_id)
    {
        $appConfig = $this->di->getRegistry()->getAppConfig();
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $collection = $mongo->getCollection('cedcommerce_app_shops');
        $installApps = $appModel->getSubUserWithApp([
            ['apps._id' => $appConfig['sub_app_id']],
        ]);
        $cedApp = $appModel->getSubUserWithApp([
            ['apps.app_marketplace' => "cedcommerce"],
            ['_id' => $installApps[0]->_id],
        ]);

        $cedAppShop = $collection->findOne(['remote_shop_id' => $remote_shop_id]);

        if (!empty($cedApp) && empty($cedAppShop)) {
            $insertData = [
                'remote_shop_id' => $remote_shop_id,
                'sAppId' => $appConfig['sub_app_id'],
                'ced_subuser_id' => $installApps[0]->_id,
                'ced_sAppId' => $cedApp[0]->apps->_id
            ];
            $collection->insertOne($insertData);
        }
    }

    public function addApp($shopData)
    {
        $appDetail = [
            'is_visible' => false,
            'shop_id' => $shopData['_id']
        ];
        $appCreateResponse = $this->di->getObjectManager()->get('\App\Apiconnect\Api\Apps')->update($appDetail);
        if (isset($appCreateResponse['success']) && $appCreateResponse['success']) {
            return $appCreateResponse['app_id'] ?? false;
        } else {
            return false;
        }
    }

    public function addShop($shopDetail, $uniqueKeys = [], $partialUpdate = false)
    {

        if (empty($shopDetail)) {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insuficiant_data'];
        }

        $appConfig = $this->di->getRegistry()->getAppConfig();

        if (empty($appConfig)) {
            return ['success' => false, 'message' => 'App_Config not found', 'code' => 'insuficiant_data'];
        }

        $appId = $appConfig['_id'] ?? false;
        $subAppId = $appConfig['sub_app_id'] ?? false;

        unset($shopDetail['sub_apps'], $shopDetail['app_id'], $shopDetail['group_code'], $shopDetail['app_code'], $shopDetail['_id']);

        $result = [];
        $filters = [];

        $collection = $this->getCollection();
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];

        foreach ($uniqueKeys as $key) {
            if (isset($shopDetail[$key])) {
                $filters["{$key}"] = $shopDetail[$key];
            }
        }

        if (!empty($filters)) {
            $filters['group_code'] = $appConfig['group_code'];
        } else {
            return ['success' => false, 'message' => 'Shop filter can not be blank', 'code' => 'insuficiant_data'];
        }

        try {
            $shopData = [];
            $response = $collection->findOne($filters, $options);
            if ($appId && $subAppId) {
                if (empty($response)) {
                    /* add sub app in shopDetails*/
                    $shopData['_id'] = $this->getCounter('app_shop_id');
                    $shopData = array_merge($shopData, $filters);
                    $shopData['sub_apps'] = [$subAppId];
                    if (isset($shopDetail['is_private'])) {
                        $appCreateRes = $this->addApp($shopData);
                        if (!$appCreateRes) {
                            return ['success' => false, 'message' => 'Private apps needs to create a cif app. Please add is_is_privatecustom index in shop_details'];
                        }
                        $shopDetail['cif_app_id'] = $appCreateRes;
                    }
                    $this->formatShopData($shopData, $shopDetail, $appConfig, $partialUpdate);
                    $shop = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
                    $shop->setData($shopData);
                    $shop->save();
                    $result = [
                        'success' => true,
                        'message' => 'Shop Added  Successfuly app',
                        'data' => [
                            'shop_id' => $shopData['_id']
                        ]
                    ];
                    $this->checkForCedcommerceApp($shopData['_id']);
                } else {
                    if (isset($response['group_code'])) {
                        unset($response['group_code']);
                    }
                    $shopData = $response;
                    foreach ($response['apps'] as $key => $app) {
                        if ($app['app_code'] == $appConfig['app_code']) {
                            $matchedPosition = $key;
                            if (isset($app['cif_app_id'])) {
                                $shopDetail['cif_app_id'] = $app['cif_app_id'];
                            }
                        }
                    }

                    $shopData['sub_apps'] = $response['sub_apps'];
                    $sub_apps = array_flip($response['sub_apps']);

                    if (isset($matchedPosition)) {
                        $this->formatShopData($shopData, $shopDetail, $appConfig, $partialUpdate, $matchedPosition);
                        $installedApps = $response['apps'][$matchedPosition];

                        if ($this->isAppUpdated($installedApps, $shopData['apps'][$matchedPosition]) || !isset($sub_apps[$subAppId])) {
                            if (!isset($sub_apps[$subAppId]))
                                $shopData['sub_apps'][] = $subAppId;

                            $updateResult = $collection->updateOne(
                                $filters,
                                ['$set' => $shopData]
                            );

                            if ($updateResult->getMatchedCount()) {
                                $result = [
                                    'success' => true,
                                    'message' => 'Shop Updated Successfuly',
                                    'data' => [
                                        'shop_id' => $response['_id']
                                    ]
                                ];
                            } else {
                                $result = ['success' => false, 'message' => 'Shop Update Failed'];
                            }
                        } else {
                            $this->checkForCedcommerceApp($shopData['_id']);
                            $result = [
                                'success' => true,
                                'message' => 'Shop up-to-date',
                                'data' => [
                                    'shop_id' => $response['_id']
                                ]
                            ];
                        }
                    } else {
                        $shopData = $response;
                        if (!isset($sub_apps[$subAppId]))
                            $shopData['sub_apps'][] = $subAppId;
                        if (isset($shopDetail['is_private'])) {
                            $appCreateRes = $this->addApp($shopData);
                            if (!$appCreateRes) {
                                return ['success' => false, 'message' => 'Private apps needs to create a cif app. Please add is_is_privatecustom index in shop_details'];
                            }
                            $shopDetail['cif_app_id'] = $appCreateRes;
                        }
                        $this->formatShopData($shopData, $shopDetail, $appConfig, $partialUpdate, count($shopData['apps']));
                        $shop = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
                        $shop->setData($shopData);
                        $shop->save();
                        $result = [
                            'success' => true,
                            'message' => 'Shop Updated Successfuly',
                            'data' => [
                                'shop_id' => $shopData['_id']
                            ]
                        ];
                    }
                }
            } else {
                return ['success' => false, 'message' => 'appId and subAppId required params', 'code' => 'insuficiant_data'];
            }
        } catch (\Exception $e) {
            $result = ['success' => false, 'message' => $e->getMessage(), 'code' => 'unknown_exception'];
        }

        return $result;
    }

    public function isAppUpdated($existingApps, $newApps)
    {
        $updated = false;

        if (count($existingApps) != count($newApps)) {
            $updated = true;
        }

        foreach ($newApps as $key => $value) {
            if (!array_key_exists($key, $existingApps)) {
                $updated = true;
                break;
            } else {
                if (is_array($value)) {
                    $diff = array_diff_assoc($value, $existingApps[$key]);
                    if (!empty($diff)) {
                        $updated = true;
                        break;
                    }

                    $diff = array_diff_assoc($existingApps[$key], $value);
                    if (!empty($diff)) {
                        $updated = true;
                        break;
                    }
                } else {
                    if ($value !== $existingApps[$key]) {
                        $updated = true;
                        break;
                    }
                }
            }
        }

        return $updated;
    }

    public function getShop($appId = false, $subAppId = false, $shopDetails = [], $uniqueKeys = ['domain'], $findAll = false)
    {
        unset($shopDetails['app_id']);
        unset($shopDetails['sub_apps']);
        $appConfig = $this->di->getRegistry()->getAppConfig();
        if ($appConfig && !$appId) {
            $appId = $appConfig['_id'];
        }

        if ($appConfig && !$subAppId) {
            $subAppId = $appConfig['sub_app_id'] ?? false;
        }
        /*if (empty($shopDetails)) {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insuficiant_data'];
        }*/
        $collection = $this->getCollection();
        $filters = [];

        if ($appId)
            $filters['apps.app_id'] = $appId;


        if (!$findAll && $subAppId) {
            $filters['apps.sub_app_id'] = $subAppId;
        }
        
        foreach ($uniqueKeys as $key) {
            if (isset($shopDetails[$key])) {
                $filters["{$key}"] = $shopDetails[$key];
            }
        }
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];
        try {
            $response = $collection->findOne($filters, $options);
            if (empty($response)) {
                return ['success' => false, 'code' => 'shop_not_found', 'message' => 'Shop Not Found.'];
            } else {
                return ['success' => true, 'message' => '', 'data' => ['shop_id' => $response['_id'], 'datos' => $response]];
            }
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage(), 'code' => 'unknown_exception'];
        }
    }

    public function getById($shopId, $appId = false, $subAppId = false)
    {
        $appConfig = $this->di->getRegistry()->getAppConfig();
        // print_r($appConfig);die;
        if ($appConfig && !$appId) {
            $appId = $appConfig['_id'];
        }

        if ($appConfig && !$subAppId) {
            $subAppId = $appConfig['sub_app_id'] ?? false;
        }

        $filters = ['_id' => (string)$shopId];

        if ($appId) $filters['apps.app_id'] = $appId;
        if ($subAppId) $filters['sub_apps'] = $subAppId;
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];
        $collection = $this->getCollection();
        $response = $collection->findOne($filters, $options);
        return $response;
    }

    public function deleteShop($id = '')
    {
        if (empty($id)) return [
            'success' => false,
            'message' => 'id field required'
        ];
        $collection = $this->getCollection();
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];
        $response = $collection->deleteOne(
            ['_id' => (string)$id],
            $options
        );

        if ($response->getDeletedCount() == 1) {
            return [
                'success' => true,
                'message' => 'shop Successfuly deleted'
            ];
        } else {
            return [
                'success' => false,
                'message' => 'No shop found'
            ];
        }
    }

    public function getAllConnectedShops($remoteShopIdArray = [])
    {
        try {
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            $collection = $this->getCollection();
            $remoteShopIdIntConvert = [];
            foreach ($remoteShopIdArray as $shopId) {
                $remoteShopIdIntConvert[] = (string)$shopId;
            }
            $response = $collection->find(['_id' => ['$in' => $remoteShopIdIntConvert]], $options)->toArray();
            return $response;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public function getAppInShopById($shopId, $appId)
    {
        try {
            $collection = $this->getCollection();
            $query = [
                [
                    '$match' => [
                        '_id' => $shopId,
                        'apps.app_id' => $appId
                    ]
                ],
                [
                    '$unwind' => '$apps'
                ],
                [
                    '$match' => [
                        '_id' => $shopId,
                        'apps.app_id' => $appId
                    ]
                ],
            ];
            $app = $collection->aggregate($query)->toArray();
            return $app[0]['apps'];
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
    public function changeAppShopStatus($shopId, $appCode, $appStatus)
    {
        try {
            $collection = $this->getCollection();
            $appStatus = $appStatus == 'active' ? true : false;
            $result = $collection->updateOne(
                ['_id' => $shopId],
                ['$set' => ['apps.$[app].active' => $appStatus]],
                ['arrayFilters' => [
                    ['app.app_code' => $appCode]
                ]]
            );
            return $result->getModifiedCount();
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
