<?php

namespace App\Apiconnect\Components;

use mysql_xdevapi\Exception;
use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Token extends \App\Apiconnect\Api\Base
{

    /**
     * Before anything happens
     * @param Event $event
     * @param \Phalcon\Mvc\Application $application
     * @return bool
     */
    public function createBefore(Event $event, $user)
    {

        $data = $event->getData();
        $tokenDetails = $data['token_details'];
        $userGeneratedToken = $data['user_token_object'];
        if ($config = $this->di->getRegistry()->getAppConfig()) {
            $tokenDetails['app_id'] = $config['_id'];
        }

        if (isset($tokenDetails['app_id'])) {
            $userGeneratedToken->app_id = $tokenDetails['app_id'];
            $data['token']['app_id'] = $userGeneratedToken->app_id;
        }
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        if ($this->di->getRegistry()->getIsSubUser()) {
            if ($config && isset($config['sub_app_id'])) {
                $userGeneratedToken->domain = $config['domain'];
                $data['token']['sub_app_id'] = $config['sub_app_id'];
            } else {
                $userData = $this->di->getSubUser();
                if (isset($tokenDetails['app_id'])) {
                    $userApps = $appModel->getSubUserWithApp([
                        ['_id' => (string)$userData['_id']],
                        ['apps.app_id' => (string)$tokenDetails['app_id']]
                    ]);

                    $subUser = $userApps[0] ?? false;

                    if ($subUser) {
                        $userGeneratedToken->domain = $subUser->apps->domain;
                        $data['token']['sub_app_id'] = $subUser->apps->_id;
                    } else {
                        throw new \Exception('App not found.');
                    }
                }
            }

            $data['token']['subuser_id'] = $this->di->getSubUser()['_id'];
            $tokenDetails['user'] = $this->di->getSubUser()['_id'];
        } else {
            if (isset($tokenDetails['user']) && isset($tokenDetails['app_id'])) {
                $userApps = $appModel->getSubUserWithApp([
                    ['_id' => (string)$tokenDetails['user']],
                    ['apps.app_id' => (string)$tokenDetails['app_id']]
                ]);

                $subUser = $userApps[0] ?? false;
                if ($subUser) {
                    $userGeneratedToken->domain = $subUser->apps->domain;
                    $data['token']['sub_app_id'] = $subUser->apps->_id;
                } else {
                    throw new \Exception('App not found.');
                }
                $data['token']['subuser_id'] = $tokenDetails['user'];
                $tokenDetails['user'] = $tokenDetails['user'];
            }
        }
    }
}
