<?php

namespace App\Apiconnect\Components;

use Phalcon\Events\Event;
use \App\Core\Middlewares\Firewall as BaseFirewall;
/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Firewall extends BaseFirewall
{
    /**
     * @var int
     */
    public $timeLimit = 60;

    /**
     * @var int
     */
    public $throttleLimit = 50;

    /**
     * Before anything happens
     * @param Event $event
     * @param \Phalcon\Mvc\Application $application
     * @return bool
     */

    public function IsCedcommerceSubuser($subuser_id, $remote_shop_id, $application)
    {
        $appCode = $application->request->get('app_code') ? $application->request->get('app_code') : $application->request->getPut('app_code');
        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $apps_model = $this->di->getObjectManager()->get('App\Apiconnect\Models\Apps');
        $collection = $mongo->getCollection('cedcommerce_app_shops');
        $application->di->getRegistry()->setSubuserId($subuser_id);
        if ($appCode) {
            $app = $apps_model->getAppsDataByAppCode($appCode);
            $sub_app = $apps_model->getSubUserWithApp([
                ['apps.app_id' => $app['_id']],
                ['_id' => (string)$subuser_id],
            ]);
            $appConfig = $apps_model->getSubConfig($sub_app[0]->apps->_id);
            $application->di->getRegistry()->setAppConfig($appConfig);
        } else {
            $application->di->getRegistry()->setAppConfig(false);
        }
        if ($remote_shop_id) {
            $filter = [
                'remote_shop_id' => (string)$remote_shop_id,
                'ced_subuser_id' => (string)$subuser_id
            ];
            $ced_app_shops = $collection->findOne($filter, ["typeMap" => ['root' => 'array', 'document' => 'array']]);
            if (!empty($ced_app_shops)) {
                $application->di->getRegistry()->setCurrentCedAppShop($ced_app_shops);

                $subApp = $apps_model->getSubApp($ced_app_shops['sAppId']);
                $shop = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                    ->getById($remote_shop_id, $subApp->app_id, $ced_app_shops['sAppId']);
                if (!empty($shop)) {
                    $application->di->getRegistry()->setCurrentShop($shop);
                    $application->di->getRegistry()->setCurrentAppShop($this->getAppShop());
                } else {
                    $application->di->getRegistry()->setCurrentShop(false);
                    $application->di->getRegistry()->setCurrentAppShop(false);
                }
                return true;
            } else {
                return false;
            }
        }
    }

    public function beforeHandleRequest(Event $event, \Phalcon\Mvc\Application $application)
    {
        $this->di = $application->di;
        $headers = $this->get_nginx_headers();
        $token = $application->di->getRegistry()->getDecodedToken();

        $subAppId = false; //$application->di->get('session')->get('sub_app_id');
        if (isset($token['sub_app_id'])) {
            $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');
            $subAppConfig = $appsModel->getSubConfig($token['sub_app_id']);
            if (isset($subAppConfig['group_code'])) {
                //print_r($subAppConfig);die;
                $collection = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')->getCollection();
                $groupApps = $collection->find(['group_code' => $subAppConfig['group_code'], '_id' => ['$nin' => [$subAppConfig['_id']]]], ["typeMap" => ['root' => 'array', 'document' => 'array']])->toArray();

                $subAppConfig['group_apps'] = $groupApps;
            }

            $application->di->getRegistry()->setAppConfig($subAppConfig);
        } elseif (isset($headers['sAppId']) || $application->request->get('sAppId')) {
            if ($subAppId) {

                $sAppId = $subAppId;
            } else {
                $sAppId = $headers['sAppId'] ?? $application->request->get('sAppId');
            }

            $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');
            $subAppConfig = $appsModel->getSubConfig($sAppId);
            if (isset($subAppConfig['group_code'])) {
                //print_r($subAppConfig);die;
                $collection = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')->getCollection();
                $groupApps = $collection->find(['group_code' => $subAppConfig['group_code'], '_id' => ['$nin' => [$subAppConfig['_id']]]], ["typeMap" => ['root' => 'array', 'document' => 'array']])->toArray();

                $subAppConfig['group_apps'] = $groupApps;
            }

            $application->di->getRegistry()->setAppConfig($subAppConfig);
        } elseif (isset($token['app_id'])) {
            $appConfig = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')
                ->getConfig($token['app_id']);

            if (isset($appConfig['group_code'])) {
                //print_r($subAppConfig);die;
                $collection = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')->getCollection();
                $groupApps = $collection->find(['group_code' => $appConfig['group_code'], '_id' => ['$nin' => [$appConfig['_id']]]], ["typeMap" => ['root' => 'array', 'document' => 'array']])->toArray();

                $appConfig['group_apps'] = $groupApps;
            }

            $application->di->getRegistry()->setAppConfig($appConfig);
        } elseif (isset($headers['appId']) || $application->request->get('appId')) {
            $appId = $headers['appId'] ?? $application->request->get('appId');
            $appConfig = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')
                ->getConfig($appId);

            $application->di->getRegistry()->setAppConfig($appConfig);
        } elseif ($sAppId = $application->di->getConfig()->get('default_sub_appid')) {
            $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');
            $subAppConfig = $appsModel->getSubConfig($sAppId);
            if (isset($subAppConfig['group_code'])) {
                //print_r($subAppConfig);die;
                $collection = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')->getCollection();
                $groupApps = $collection->find(['group_code' => $subAppConfig['group_code'], '_id' => ['$nin' => [$subAppConfig['_id']]]], ["typeMap" => ['root' => 'array', 'document' => 'array']])->toArray();

                $subAppConfig['group_apps'] = $groupApps;
            }


            $application->di->getRegistry()->setAppConfig($subAppConfig);
        } else {

            $application->di->getRegistry()->setAppConfig(false);
        }



        if ($state = $application->request->get('state') ?? $this->fallbackStateKeys($application->request->get())) {
            $state = $application->di->getObjectManager()->get('App\Core\Components\Helper')
                ->decodeToken($state, false);
            if (isset($state['success']) && $state['success']) {
                $state = $state['data'];
                $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');

                if (isset($state['sub_app_id'])) {
                    $subAppConfig = $appsModel->getSubConfig($state['sub_app_id']);
                    if (isset($subAppConfig['group_code'])) {
                        //print_r($subAppConfig);die;
                        $collection = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')->getCollection();
                        $groupApps = $collection->find(['group_code' => $subAppConfig['group_code'], '_id' => ['$nin' => [$subAppConfig['_id']]]], ["typeMap" => ['root' => 'array', 'document' => 'array']])->toArray();

                        $subAppConfig['group_apps'] = $groupApps;
                    }


                    $application->di->getRegistry()->setAppConfig($subAppConfig);
                } elseif (isset($state['app_id'])) {
                    $appConfig = $appsModel->getConfig($state['app_id']);
                    if (isset($appConfig['group_code'])) {
                        //print_r($subAppConfig);die;
                        $collection = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')->getCollection();
                        $groupApps = $collection->find(['group_code' => $appConfig['group_code'], '_id' => ['$nin' => [$appConfig['_id']]]], ["typeMap" => ['root' => 'array', 'document' => 'array']])->toArray();

                        $appConfig['group_apps'] = $groupApps;
                    }

                    $application->di->getRegistry()->setAppConfig($appConfig);
                }
                $application->di->getRegistry()->setAppState($state);
                return true;
            } else {
                $application->di->getRegistry()->setAppState(false);
            }
        } else {
            $application->di->getRegistry()->setAppState(false);
        }
        $shopId = $application->request->get('shop_id') ? $application->request->get('shop_id') : $application->request->getPut('shop_id');



        if ($application->di->getRegistry()->getAppConfig() && $shopId) {

            $shop = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                ->getById($shopId);
            if (!$shop) {
                $config = $application->di->getRegistry()->getAppConfig();

                foreach ($config['group_apps'] as $app) {

                    $shop = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                        ->getById($shopId, $app['_id']);

                    if ($shop) {
                        break;
                    }
                }
            }
            $application->di->getRegistry()->setCurrentShop($shop);
            $application->di->getRegistry()->setCurrentAppShop($this->getAppShop());
        } else {
            $application->di->getRegistry()->setCurrentShop(false);
            $application->di->getRegistry()->setCurrentAppShop(false);
        }
        if (isset($token['subuser_id']) && !isset($token['sub_app_id'])) {
            $this->IsCedcommerceSubuser($token['subuser_id'], $shopId, $application);
        }
        return true;
    }
    /**
     * finds state's alternative key at request, defined in config.
     *
     * @param array $request
     * @return mixed
     */
    public function fallbackStateKeys($request)
    {
        foreach ($this->di->getConfig()->path("oauth_state_keys", []) as $state) {
            if (array_key_exists($state, $request))
                return $request[$state];
        }
        return null;
    }

    public function getAppShop()
    {
        $shop = $this->di->getRegistry()->getCurrentShop();
        $appShop = $this->di->getRegistry()->getAppConfig();
        foreach ($shop['apps'] as $app) {
            if ($app['app_id'] == $appShop['_id']) {
                return $app;
            }
        }
    }
}
