<?php

namespace App\Apiconnect\Api;

class SubUser extends \App\Apiconnect\Api\Base
{
    protected $_component = 'SubUser';

    /**
     * Change subuser status to active/block
     *
     * @param $requestData
     * @return void
     */
    public function changeSubUserStatus($requestData)
    {
        $allowed_type = ['inactive', 'active'];

        if (isset($requestData['userId']) && $requestData['status']) {
            if (!in_array($requestData['status'], $allowed_type))
            return ['success' => false, 'message' =>'Invalid status type! Allowed status are '.implode(', ', $allowed_type)];
            return $this->di->getObjectManager()->get('\App\Core\Models\User\SubUser')->changeSubUserStatus($requestData);
        } else {
            return ['success' => false, 'message' => 'Invalid input!'];
        }
    }
}