<?php

namespace App\Apiconnect\Api;

/**
 * Class Base
 * @package App\Apiconnect\Api
 */
class Base extends \App\Apiconnect\Components\Base
{
    /**
     * Validate Request
     *
     * @param mixed $request request object.
     * @return false/object of marketplace specific product component
     */
    public function getComponent($marketplace=false,$component=false){
        if($marketplace && $component){
            $marketplace = $this->di->getConfig()->get('marketplace-modules')
                ->get($marketplace) ?: ucfirst($marketplace);

            return $this->di->getObjectManager()->get('\App\\'.$marketplace.'\Api\\'.$component);
        }elseif ($appConfig = $this->di->getRegistry()->getAppConfig()) {
            $marketplace = $this->di->getConfig()->get('marketplace-modules')
                            ->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);

            return $this->di->getObjectManager()->get('\App\\'.$marketplace.'\Api\\'.$this->_component);
        }else {
            return false;
        }
    }

    /**
     * @param $component
     * @return $this
     */
    public function setComponent($component){
        $this->_component = $component;
        return $this;
    }

    /**
     * @param $name
     * @param $arguments
     * @return array|mixed
     */
    public function __call($name, $arguments)
    {
        try {

            if ($component = $this->getComponent()) {
                if(method_exists($component, $name)){
                    return call_user_func_array(array($component, $name), $arguments);
                }
                else{
                    return ['success' => false, 'message' => 'Method does not exist.', 'code' => 'something_went_wrong_in_call'];
                }
                
            }
            else{
                die('Component not found');
            }
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Something went wrong', 'code' => 'something_went_wrong_in_call'];
        }
    }
}
