<?php

namespace App\Apiconnect\Api;

class AppUninstall extends \App\Apiconnect\Api\Base
{
    /**
     * delete data of uninstall app from apps_shop and store backup in uninstall_apps_shop collection.
     *
     * @param array $requestData
     * @return array/json with success true/false and message
     */

    public function uninstallApp($requestData)
    {
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        try {
            if (isset($requestData['shop_id']) && isset($requestData['app_code'])) {
                $appsShopCollection = $mongo->getCollectionForTable('apps_shop');
                $shop_id = $requestData['shop_id'];
                $app_code = $requestData['app_code'];
                $appConfig = $this->di->getRegistry()->getAppConfig();
                $shop = $this->di->getRegistry()->getCurrentShop();
                $appsShopCollectionResponse = $appsShopCollection->updateOne(
                    ["_id" => $shop_id],
                    [
                        '$pull' => [
                            'apps' => ['app_code' => $app_code],
                            'sub_apps' => $appConfig['sub_app_id']
                        ],
                    ]
                );
                $appsShopCollectionResponse = $appsShopCollection->deleteOne(
                    [
                        "_id" => $shop_id,
                        "apps" => ['$size' => 0]
                    ]
                );
                if ($appsShopCollectionResponse->getDeletedCount()) {
                    $cedAppShopCollection = $mongo->getCollectionForTable('cedcommerce_app_shops');
                    $cedAppShopCollection->deleteMany(['remote_shop_id' => $shop['_id']]);
                    $uninstallAppsCollection = $mongo->getCollectionForTable('uninstall_apps_shop');
                    unset($shop['_id']);
                    unset($shop['apps']);
                    unset($shop['group_code']);
                    unset($shop['sub_apps']);
                    $uninstallAppsCollection->insertOne($shop);
                }
                return ['success' => true, 'message' => "App uninstalled successfully."];
            }
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }

    public function checkAndUpdateCedAppShop($data)
    {
        try {
            $appConfig = $this->di->getRegistry()->getAppConfig();
            $shop = $this->di->getRegistry()->getCurrentShop();
            if (isset($shop, $appConfig)) {
                if (count($shop['apps']) > 1) {
                    $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
                    $cedAppShopCollection = $mongo->getCollectionForTable('cedcommerce_app_shops');
                    $cedAppShop = $cedAppShopCollection->findOne(
                        [
                            'remote_shop_id' => $shop['_id']
                        ]
                    );
                    if (!empty($cedAppShop)) {
                        foreach ($shop['apps'] as $key => $app) {
                            if ($app['sub_app_id'] == $cedAppShop['sAppId']) {
                                $appInShop = $shop['apps'][$key];
                                break;
                            }
                        }
                        if ((!isset($appInShop)) || (isset($appInShop['app_uninstalled']) && $appInShop['app_uninstalled'])) {
                            foreach ($shop['apps'] as $app) {
                                if (!isset($app['app_uninstalled'])) {
                                    $updateResponse = $cedAppShopCollection->updateOne(
                                        [
                                            'remote_shop_id' => $shop['_id']
                                        ],
                                        [
                                            '$set' => ['sAppId' => $app['sub_app_id']]
                                        ]
                                    );
                                    $route = $this->di->getConfig()->get('restapi')->get('v1')
                                        ->get('POST')->get('routes')->get("re-register/webhooks");
                                    $method = $route->method;
                                    $class =  $route->class;
                                    if (class_exists($class)) {
                                        if (method_exists($class, $method)) {
                                            $reRegisterWebhookResponse = $this->di->getObjectManager()->get($class)->$method(['shop_id' => $shop['_id']]);
                                            return ['success' => true, 'message' => "cedAppShop update response => " . $updateResponse->getModifiedCount(), "re_registering_webhooks" => $reRegisterWebhookResponse];
                                        }
                                        return ['success' => false, 'message' => "cedAppShop update response => " . $updateResponse->getModifiedCount() . " Error in re-registering webhooks, method not found!! Method => " . $method];
                                    } else {
                                        return ['success' => false, 'message' => "cedAppShop update response => " . $updateResponse->getModifiedCount() . " Error in re-registering webhooks, class not found!! Class => " . $class];
                                    }
                                }
                            }
                            return ['success' => true, 'message' => "All the apps in shop are uninstalled."];
                        } else {
                            return ['success' => true, 'message' => "ced_app_shop is good to go."];
                        }
                    } else {
                        return ['success' => false, 'message' => 'ced_app_shop is not available for this shop.'];
                    }
                } else {
                    return ['success' => true, 'message' => "shop contian single shop."];
                }
            } else {
                $this->di->getLog()->logContent("Shop or app_config not set properly.", "info", "app_uninstall_exception.log");
                return ['success' => false, 'message' => "Shop or app_config not set properly."];
            }
        } catch (\Exception $e) {
            $this->di->getLog()->logContent($e->getMessage(), "info", "app_uninstall_exception.log");
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }
    public function setAppUninstallKeyInAppShop($data)
    {
        $appConfig = $this->di->getRegistry()->getAppConfig();
        $shop = $this->di->getRegistry()->getCurrentShop();
        if (!empty($shop) && !empty($appConfig)) {
            $shopId = $shop['_id'];
            $appInShop = $this->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')->getAppInShopById($shopId, $appConfig['_id']);
            if (isset($appInShop['app_uninstalled']) && $appInShop['app_uninstalled'])
                return ['success' => true, 'message' => "app_uninstalled key already added."];
            $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $appsShop = $mongo->getCollectionForTable('apps_shop');
            $isUpdated = $appsShop->updateOne(
                ['_id' => $shopId],
                [
                    '$set' => [
                        'apps.$[app].app_uninstalled' => true
                    ]
                ],
                [
                    'arrayFilters' => [
                        [
                            'app.app_code' => $appConfig['app_code']
                        ]
                    ]
                ]
            );
            if ($isUpdated->getModifiedCount())
               return ['success' => true, 'message' => "app_uninstalled key added successfully."];
            return ['success' => false, 'message' => "Trouble in adding app_uninstalled key."];
        } else {
            return ['success' => false, 'message' => "shop_id missing or app_config not set."];
        }
    }
}
