<?php

namespace App\Apiconnect\Api;

class AppShop extends \App\Apiconnect\Api\Base
{
    protected $_component = 'AppShop';

    /**
     * get one product/ get product list.
     *
     * @param array $requestData
     * @return array/json with success true/false and message
     */
    public function get($requestData)
    {
        if (isset($requestData['shop_data']) && $requestData['unique_keys']) {
            return $this->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                    ->getShop(false, false, $requestData['shop_data'], $requestData['unique_keys'], true);
        } else {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insufficient_data'];
        }
    }

    public function set($requestData)
    {
        if (isset($requestData['shop_id'])) {
            return $this->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                    ->addShop(false, false, ['_id'=>$requestData['shop_id']], ['_id']);
        } else {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insufficient_data'];
        }
    }

    public function delete($requestData)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                // if(is_array($requestData['shop_ids']))
                // {
                //     $response = [];

                //     foreach ($$requestData['shop_ids'] as $id) {
                //         $resp = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->deleteShop($id);
                //         if($resp['success']) {
                //             $response['success'][$id] = $id;
                //         }
                //         else {
                //             $response['error'][$id] = $resp['message'];
                //         }

                //         if(isset($response['success'])) {
                //             return [
                //                 'success'   => true,
                //                 'data'      => $response
                //             ];
                //         }
                //         else {
                //             return [
                //                 'success'   => false,
                //                 'msg'       => $response['error']
                //             ];
                //         }
                //     }
                // }
                // else
                // {
                    $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->deleteShop($requestData['shop_id']);

                    if(isset($shop['success'])) {
                        return [
                            'success' => true,
                            'data' => $requestData['shop_id']
                        ];
                    }
                    else {
                        return [
                            'success' => false,
                            'msg' => $shop['message']
                        ];
                    }
                // }
            }
            else
            {
                die('shop_id not found.');
            }
        } catch (\Exception $exception) {
            return $exception->getMessage();
        }
    }

    public function getConnectedAccounts($requestData){
        if(isset($requestData['remote_shop_id'])){
            $homeShopsArray = $requestData['remote_shop_id'];
            $remoteShopdata = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->getAllConnectedShops($homeShopsArray);
            return ['success' => true, 'data' => $remoteShopdata];
        }else return ['success' => false, 'message' => 'Shop data missing'];
    }

    public function addAppShop($data){
        $appConfig = $this->di->getRegistry()->getAppConfig();
        if (empty($appConfig) && !isset($appConfig['marketplace'])){
            return ['success' => false, 'message' =>"App Config not found."];
        }
        $data = $data['data'];
        if(isset($data['marketplaceAddShop'])){
            $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);
            
            $marketplaceHandler = $this->di->getObjectManager()->get('\App\\' .$targetMarketplace. '\\Components\Route\Handler');
            $shop = $marketplaceHandler->addAppShop($data['shop_data']);
            if($shop['success']){
                $response =['success'=>true];
                if (isset($appConfig['marketplace']))
                    $shop['data']['marketplace'] = $appConfig['marketplace'];
                if (isset($appConfig['app_code']))
                    $response['app_code'] = $appConfig['app_code'];
                $response['data'] = $shop['data'];
            }elseif (isset($shop['message'])){
                $response = [
                    'success'=>false,
                    'msg'=>$shop['message']
                ];
            }
            return $response;
        }
        
        $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop($data['shop_data'], $data['unique_keys']);
        $response = [];
        if($shop['success']){
            $response =['success'=>true];
            if (isset($appConfig['marketplace']))
                $shop['data']['marketplace'] = $appConfig['marketplace'];
            if (isset($appConfig['app_code']))
                $response['app_code'] = $appConfig['app_code'];
            $response['data'] = $shop['data'];
        }elseif (isset($shop['message'])){
            $response = [
                'success'=>false,
                'msg'=>$shop['message']
            ];
        }
        return $response;
    }

    public function changeAppShopStatus($data)
    {
        $shop = $this->di->getRegistry()->getCurrentShop();
        $data = $data['data'];
        if (isset($data['status']) && !empty($shop) && ($data['status'] == 'active' || $data['status'] == 'inactive')) {
            if ($this->di->getRegistry()->getCurrentCedAppShop() && isset($data['app_code'])) {
                $appCode = $data['app_code'];
            } elseif ($this->di->getRegistry()->getAppConfig()) {
                $appConfig = $this->di->getRegistry()->getAppConfig();
                $appCode = $appConfig['app_code'];
            } else {
                return ['success' => false, 'message' => 'Unable to fetch app_code.'];
            }
            foreach ($shop['apps'] as $app) {
                if ($app['app_code'] == $appCode) {
                    if (($data['status'] == 'active' && $app['active']) || ($data['status'] == "inactive" && !$app['active'])) {
                        return ['success' => true, "message" => "Status is already set " . $data['status']];
                    } else {
                        $result =  $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->changeAppShopStatus($shop['_id'], $appCode, $data['status']);
                        if ($result)
                            return ['success' => true, 'message' => "Status Updated Successfully"];
                        return ['success' => false, 'message' => "Trouble in updating status "];
                    }
                }
            }
            return ['success' => false, 'message' => "app is not present in that shop."];
        } else {
            return ['success' => false, 'message' => "Data missing status (active or inactive) or shop_id key. Or might be trouble in setting current shop in DI"];
        }
    }
}
